<?php
// index.php - user form (professional design inspired by Apple/Google)
// No frameworks. Make sure PHP can write to requests.json (chmod 664 or 666 for testing).
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_code = trim($_POST['current_code'] ?? '');
    $mobile = trim($_POST['mobile'] ?? '');
    $room = trim($_POST['room'] ?? '');

    // Function to check if string contains only English characters, numbers, and basic punctuation
    function isEnglishOnly($text) {
        // Allow English letters, numbers, spaces, and basic punctuation (.,!?-_)
        return preg_match('/^[a-zA-Z0-9\s.,!?\-_]+$/', $text);
    }

    // Function to check if code has made a request in the last 6 hours
    function canMakeRequest($current_code) {
        $file = __DIR__ . '/requests.json';
        if (!file_exists($file)) {
            return true; // No previous requests
        }
        
        $json = @file_get_contents($file);
        $data = $json ? json_decode($json, true) : [];
        if (!is_array($data)) return true;
        
        $sixHoursAgo = time() - (6 * 60 * 60); // 6 hours in seconds
        
        foreach ($data as $request) {
            if ($request['current_code'] === $current_code) {
                $requestTime = strtotime($request['created_at']);
                if ($requestTime > $sixHoursAgo) {
                    return false; // Found a request within last 6 hours
                }
            }
        }
        
        return true; // No recent requests found
    }

    if ($current_code === '' || $mobile === '' || $room === '') {
        $error = "অনুগ্রহ করে সমস্ত ঘর পূরণ করুন।";
    } elseif (!isEnglishOnly($current_code)) {
        $error = "বর্তমান কোডে শুধুমাত্র ইংরেজি অক্ষর ব্যবহার করুন।";
    } elseif (!isEnglishOnly($room)) {
        $error = "রুম নম্বরে শুধুমাত্র ইংরেজি অক্ষর ব্যবহার করুন।";
    } elseif (!preg_match('/^[0-9]+$/', $mobile)) {
        $error = "মোবাইল নম্বরে শুধুমাত্র সংখ্যা ব্যবহার করুন।";
    } elseif (!canMakeRequest($current_code)) {
        $error = "এই কোড দিয়ে ইতিমধ্যে গত ৬ ঘন্টার মধ্যে অনুরোধ করা হয়েছে। অনুগ্রহ করে ৬ ঘন্টা পর আবার চেষ্টা করুন।";
    } else {
        $new_code = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
        $id = uniqid('req_', true); // unique request id

        // Set timezone to GMT+6 (Bangladesh Standard Time)
        date_default_timezone_set('Asia/Dhaka');
        
        $entry = [
            'id' => $id,
            'current_code' => $current_code,
            'new_code' => $new_code,
            'mobile' => $mobile,
            'room' => $room,
            'created_at' => date('Y-m-d H:i:s'),
            'created_at_gmt6' => date('Y-m-d H:i:s T'),
            'status' => 'pending'
        ];

        $file = __DIR__ . '/requests.json';
        $data = [];
        if (file_exists($file)) {
            $json = @file_get_contents($file);
            $data = $json ? json_decode($json, true) : [];
            if (!is_array($data)) $data = [];
        }
        $data[] = $entry;
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
        
        // Redirect to success page with the new code
        header("Location: success.php?code=" . urlencode($new_code));
        exit;
    }
}
?>
<!doctype html>
<html lang="bn">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no" />
<title>ভুলবশত বন্ধুকে কোড দিয়েছেন? নতুন ওয়াইফাই কোডের জন্য অনুরোধ করুন< </title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
:root {
    --primary: #0071e3;
    --primary-light: #e6f2ff;
    --secondary: #86868b;
    --success: #30d158;
    --success-light: #f0fff4;
    --error: #ff3b30;
    --error-light: #fff2f2;
    --warning: #ff9500;
    --warning-light: #fff8e6;
    --info: #5ac8fa;
    --info-light: #f0f9ff;
    --white: #ffffff;
    --light-gray: #f5f5f7;
    --medium-gray: #d2d2d7;
    --dark-gray: #1d1d1f;
    --text: #1d1d1f;
    --text-secondary: #86868b;
    --shadow: 0 4px 24px rgba(0, 0, 0, 0.08);
    --shadow-hover: 0 8px 32px rgba(0, 0, 0, 0.12);
    --border-radius: 12px;
    --border-radius-large: 18px;
    --transition: all 0.2s ease;
}

* {
    box-sizing: border-box;
    font-family: 'Inter', 'Noto Sans Bengali', -apple-system, BlinkMacSystemFont, sans-serif;
}

body {
    margin: 0;
    background-color: var(--white);
    color: var(--text);
    padding: 20px;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    line-height: 1.5;
}

.container {
    max-width: 560px;
    width: 100%;
}

.card {
    background-color: var(--white);
    border-radius: var(--border-radius-large);
    padding: 40px;
    box-shadow: var(--shadow);
    transition: var(--transition);
    border: 1px solid var(--medium-gray);
}

.header {
    text-align: center;
    margin-bottom: 40px;
}

.logo {
    width: 60px;
    height: 60px;
    background-color: var(--primary-light);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
}

.logo i {
    font-size: 24px;
    color: var(--primary);
}

h1 {
    font-size: 28px;
    font-weight: 600;
    margin: 0 0 10px;
    color: var(--text);
}

.subtitle {
    font-size: 16px;
    color: var(--text-secondary);
    margin: 0;
    line-height: 1.5;
}

.alert {
    padding: 16px 20px;
    border-radius: var(--border-radius);
    margin-bottom: 24px;
    font-size: 15px;
    display: flex;
    align-items: center;
}

.alert-error {
    background-color: var(--error-light);
    border-left: 4px solid var(--error);
    color: var(--error);
}

.alert-icon {
    margin-right: 12px;
    font-size: 18px;
}

.form-section {
    margin-bottom: 32px;
}

.form-group {
    margin-bottom: 24px;
}

label {
    display: block;
    font-size: 15px;
    font-weight: 500;
    margin-bottom: 8px;
    color: var(--text);
}

input[type=text], input[type=tel] {
    width: 100%;
    padding: 14px 16px;
    border-radius: var(--border-radius);
    border: 1px solid var(--medium-gray);
    font-size: 16px;
    background-color: var(--white);
    transition: var(--transition);
    -webkit-appearance: none;
}

input[type=text]:focus, input[type=tel]:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(0, 113, 227, 0.1);
}

input.invalid {
    border-color: var(--error);
    background-color: var(--error-light);
}

.validation-message {
    font-size: 13px;
    color: var(--error);
    margin-top: 6px;
    display: none;
}

button {
    background-color: var(--primary);
    color: var(--white);
    border: 0;
    padding: 14px 24px;
    border-radius: var(--border-radius);
    font-weight: 500;
    font-size: 16px;
    cursor: pointer;
    width: 100%;
    transition: var(--transition);
    box-shadow: 0 2px 8px rgba(0, 113, 227, 0.2);
}

button:hover {
    background-color: #0077ed;
    box-shadow: 0 4px 12px rgba(0, 113, 227, 0.3);
}

button:active {
    transform: translateY(1px);
}

.info-card {
    background-color: var(--light-gray);
    border-radius: var(--border-radius);
    padding: 24px;
    margin-bottom: 24px;
}

.info-card h3 {
    font-size: 18px;
    font-weight: 600;
    margin-top: 0;
    margin-bottom: 16px;
    color: var(--text);
    display: flex;
    align-items: center;
}

.info-card h3 i {
    margin-right: 10px;
    color: var(--primary);
}

.info-card ul {
    margin: 0;
    padding-left: 20px;
}

.info-card ul li {
    margin-bottom: 8px;
    font-size: 15px;
}

.info-card ul li:last-child {
    margin-bottom: 0;
}

.footer {
    font-size: 14px;
    color: var(--text-secondary);
    text-align: center;
    margin-top: 24px;
}

.footer a {
    color: var(--primary);
    text-decoration: none;
}

.footer a:hover {
    text-decoration: underline;
}

.divider {
    height: 1px;
    background-color: var(--medium-gray);
    margin: 32px 0;
}

@media (max-width: 480px) {
    body { padding: 16px; }
    .card { padding: 24px; }
    h1 { font-size: 24px; }
}
</style>
</head>
<body>
<div class="container">
  <div class="card">
    <div class="header">
      <div class="logo">
        <i class="fas fa-wifi"></i>
      </div>
      <div style="font-family: 'SolaimanLipi', sans-serif; line-height:1.6; color:#333;">
  <h2 style="color:#d32f2f; font-weight:bold; text-align:center;">
    ভুলবশত বন্ধুকে কোড দিয়েছেন? নতুন ওয়াইফাই কোডের জন্য অনুরোধ করুন
  </h2>
  <br/>
  <h4 style="color:#1976d2; font-weight:600; text-align:center;">
    আগের কোডটি পরিবর্তন করে আপনি নতুন কোড পাবেন। 
    <span style="color:#d32f2f;">মনে রাখবেন, নতুন কোড কখনোই অন্য কারও সাথে শেয়ার করবেন না।</span>
  </h4>
  <p class="subtitle" style="background:#f5f5f5; padding:12px; border-left:4px solid #1976d2; border-radius:6px;">
    আপনার বর্তমান কোড, মোবাইল নম্বর এবং রুম নম্বর প্রদান করুন।  
    সাবমিট করার পর নতুন কোড ব্যবহার করার আগে অনুগ্রহ করে <strong>মারুফ ভাই কে কল বা হোয়াটসঅ্যাপে মেসেজ করুন </strong>।
  </p>
</div>


</div>

    <?php if(!empty($error)): ?>
      <div class="alert alert-error">
        <span class="alert-icon">⚠️</span>
        <?=htmlspecialchars($error)?>
      </div>
    <?php endif; ?>

    <div class="form-section">
      <form method="post" autocomplete="off" id="mainForm">
        <div class="form-group">
          <label for="current_code">বর্তমান কোড</label>
          <input id="current_code" name="current_code" type="text" placeholder="যেমন 8465Z" required>
          <div class="validation-message" id="current_code_error">শুধুমাত্র ইংরেজি অক্ষর, সংখ্যা এবং সাধারণ চিহ্ন ব্যবহার করুন</div>
        </div>

        <div class="form-group">
          <label for="mobile">মোবাইল নম্বর</label>
          <input id="mobile" name="mobile" type="tel" pattern="[0-9]*" placeholder="০১XXXXXXXXX" required>
          <div class="validation-message" id="mobile_error">শুধুমাত্র সংখ্যা ব্যবহার করুন</div>
        </div>

        <div class="form-group">
          <label for="room">রুম নম্বর</label>
          <input id="room" name="room" type="text" placeholder="রুম ৩০৫" required>
          <div class="validation-message" id="room_error">শুধুমাত্র ইংরেজি অক্ষর, সংখ্যা এবং সাধারণ চিহ্ন ব্যবহার করুন</div>
        </div>

        <button type="submit">অনুরোধ জমা দিন</button>
      </form>
    </div>

    <div class="divider"></div>

    <div class="info-card">
      <h3><i class="fas fa-info-circle"></i> তথ্য</h3>
      <ul>
        <li>প্রতি ৬ ঘন্টায় একবার অনুরোধ করতে পারবেন</li>
        <li>নতুন কোড ব্যবহার করার আগে ১০ মিনিট অপেক্ষা করুন</li>
        <li>অনুরোধ গ্রহণের জন্য মারুফ ভাইকে জানাতে হবে</li>
        <li>প্রয়োজনে, স্ট্যাটাস জানতে অ্যাডমিন প্যানেল চেক করতে বলুন</li>
      </ul>
    </div>

    <div class="footer">
      <p>© 2023 RvWIFI Payment</p>
    </div>
  </div>
</div>

<script>
// Real-time validation functions
function validateEnglishOnly(text) {
    return /^[a-zA-Z0-9\s.,!?\-_]*$/.test(text);
}

function validateNumbersOnly(text) {
    return /^[0-9]*$/.test(text);
}

function showValidationError(fieldId, show) {
    const field = document.getElementById(fieldId);
    const errorMsg = document.getElementById(fieldId + '_error');
    
    if (show) {
        field.classList.add('invalid');
        errorMsg.style.display = 'block';
    } else {
        field.classList.remove('invalid');
        errorMsg.style.display = 'none';
    }
}

// Real-time validation on input
document.getElementById('current_code').addEventListener('input', function(e) {
    const isValid = validateEnglishOnly(e.target.value);
    showValidationError('current_code', !isValid && e.target.value.length > 0);
});

document.getElementById('mobile').addEventListener('input', function(e) {
    const isValid = validateNumbersOnly(e.target.value);
    showValidationError('mobile', !isValid && e.target.value.length > 0);
    
    // Remove non-numeric characters automatically
    if (!isValid) {
        e.target.value = e.target.value.replace(/[^0-9]/g, '');
    }
});

document.getElementById('room').addEventListener('input', function(e) {
    const isValid = validateEnglishOnly(e.target.value);
    showValidationError('room', !isValid && e.target.value.length > 0);
});

// Form validation on submit
document.getElementById('mainForm').addEventListener('submit', function(e) {
    const currentCode = document.getElementById('current_code').value;
    const mobile = document.getElementById('mobile').value;
    const room = document.getElementById('room').value;
    
    let hasError = false;
    
    if (!validateEnglishOnly(currentCode)) {
        showValidationError('current_code', true);
        hasError = true;
    }
    
    if (!validateNumbersOnly(mobile)) {
        showValidationError('mobile', true);
        hasError = true;
    }
    
    if (!validateEnglishOnly(room)) {
        showValidationError('room', true);
        hasError = true;
    }
    
    if (hasError) {
        e.preventDefault();
        return false;
    }
});

// Prevent pasting of non-English characters
document.getElementById('current_code').addEventListener('paste', function(e) {
    setTimeout(() => {
        if (!validateEnglishOnly(e.target.value)) {
            e.target.value = e.target.value.replace(/[^a-zA-Z0-9\s.,!?\-_]/g, '');
            showValidationError('current_code', false);
        }
    }, 10);
});

document.getElementById('mobile').addEventListener('paste', function(e) {
    setTimeout(() => {
        if (!validateNumbersOnly(e.target.value)) {
            e.target.value = e.target.value.replace(/[^0-9]/g, '');
            showValidationError('mobile', false);
        }
    }, 10);
});

document.getElementById('room').addEventListener('paste', function(e) {
    setTimeout(() => {
        if (!validateEnglishOnly(e.target.value)) {
            e.target.value = e.target.value.replace(/[^a-zA-Z0-9\s.,!?\-_]/g, '');
            showValidationError('room', false);
        }
    }, 10);
});
</script>
</body>
</html>