<?php
// index.php - user form (mobile optimized)
// No frameworks. Make sure PHP can write to requests.json (chmod 664 or 666 for testing).
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_code = trim($_POST['current_code'] ?? '');
    $mobile = trim($_POST['mobile'] ?? '');
    $room = trim($_POST['room'] ?? '');

    if ($current_code === '' || $mobile === '' || $room === '') {
        $error = "অনুগ্রহ করে সমস্ত ঘর পূরণ করুন।";
    } else {
        $new_code = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
        $id = uniqid('req_', true); // unique request id

        $entry = [
            'id' => $id,
            'current_code' => $current_code,
            'new_code' => $new_code,
            'mobile' => $mobile,
            'room' => $room,
            'created_at' => gmdate('Y-m-d H:i:s'),
            'status' => 'pending'
        ];

        $file = __DIR__ . '/requests.json';
        $data = [];
        if (file_exists($file)) {
            $json = @file_get_contents($file);
            $data = $json ? json_decode($json, true) : [];
            if (!is_array($data)) $data = [];
        }
        $data[] = $entry;
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
        $success = true;
    }

}
?>
<!doctype html>
<html lang="bn">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>নতুন ওয়াইফাই কোডের জন্য অনুরোধ</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;500;700&display=swap" rel="stylesheet">
<style>
:root {
    --primary-color: #4a90e2;
    --success-color: #50e3c2;
    --error-color: #e94e77;
    --bg-color: #f4f7f6;
    --card-bg: #ffffff;
    --text-color: #333333;
    --muted-color: #888888;
}
* {
    box-sizing: border-box;
    font-family: 'Noto Sans Bengali', sans-serif;
}
body {
    margin: 0;
    background-color: var(--bg-color);
    color: var(--text-color);
    padding: 20px;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
}
.container {
    max-width: 480px;
    width: 100%;
}
.card {
    background-color: var(--card-bg);
    border-radius: 20px;
    padding: 25px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}
.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 40px rgba(0,0,0,0.12);
}
h1 {
    font-size: 24px;
    font-weight: 700;
    margin: 0 0 10px;
    color: var(--primary-color);
    text-align: center;
}
p.small {
    font-size: 14px;
    color: var(--muted-color);
    text-align: center;
    margin-bottom: 20px;
}
label {
    display: block;
    font-size: 16px;
    margin: 15px 0 8px;
    color: var(--text-color);
    font-weight: 500;
}
input[type=text], input[type=tel] {
    width: 100%;
    padding: 15px;
    border-radius: 12px;
    border: 1px solid #ddd;
    font-size: 16px;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
}
input[type=text]:focus, input[type=tel]:focus {
    outline: none;
    border-color: var(--primary-color);
    box-shadow: 0 0 0 3px rgba(74, 144, 226, 0.2);
}
button {
    background: linear-gradient(45deg, var(--primary-color), #3a7bd5);
    color: #fff;
    border: 0;
    padding: 15px 20px;
    border-radius: 12px;
    font-weight: 700;
    font-size: 18px;
    cursor: pointer;
    width: 100%;
    margin-top: 20px;
    transition: transform 0.2s ease, box-shadow 0.2s ease;
}
button:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
}
.success, .notice {
    padding: 15px;
    border-radius: 12px;
    margin-bottom: 20px;
    text-align: center;
    animation: fadeIn 0.5s ease;
}
.success {
    background-color: #e6fffa;
    border-left: 5px solid var(--success-color);
}
.notice {
    background-color: #fff0f3;
    border-left: 5px solid var(--error-color);
}
.footer {
    font-size: 12px;
    color: var(--muted-color);
    text-align: center;
    margin-top: 20px;
}
#newCode {
    font-weight: 700;
    font-size: 28px;
    letter-spacing: 3px;
    color: var(--primary-color);
    margin: 10px 0;
    display: block;
}
.button-group {
    display: flex;
    gap: 10px;
    margin-top: 15px;
}
.button-group button {
    margin-top: 0;
    flex: 1;
}
#screenshotBtn {
    background: #333;
}
#boldMsg {
    margin-top: 15px;
    font-weight: 700;
    font-size: 16px;
    display: none;
    animation: fadeIn 0.5s ease;
}
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}
</style>
</head>
<body>
<div class="container">
  <div class="card">
    <h1>নতুন ওয়াইফাই কোডের জন্য অনুরোধ করুন</h1>
    <p class="small">আপনার বর্তমান কোড, মোবাইল নম্বর এবং রুম নম্বর দিন। সাবমিট করার পর, নতুন কোড ব্যবহার করার আগে <strong>১০ মিনিট</strong> অপেক্ষা করুন।</p>

    <?php if(!empty($error)): ?>
      <div class="notice"><?=htmlspecialchars($error)?></div>
    <?php endif; ?>

    <?php if(!empty($success)): ?>
      <div class="success">
        <div style="font-weight:700; font-size: 18px;">অনুরোধ জমা দেওয়া হয়েছে!</div>
        <div style="margin-top:10px">আপনার নতুন কোড: <span id="newCode"><?php echo htmlspecialchars($new_code); ?></span></div>
        <div class="small" style="margin-top:8px">নতুন কোড ব্যবহার করার আগে দয়া করে <strong>১০ মিনিট</strong> অপেক্ষা করুন।</div>
        <div class="button-group">
          <button id="copyBtn">কোড কপি করুন</button>
          <button id="screenshotBtn">স্ক্রিনশট নিন</button>
        </div>
        <div id="boldMsg"></div>
      </div>
    <?php endif; ?>

    <form method="post" autocomplete="off">
      <label for="current_code">বর্তমান কোড</label>
      <input id="current_code" name="current_code" type="text" placeholder="যেমন 8465Z" required>

      <label for="mobile">মোবাইল (০১xxxxxxxxx)</label>
      <input id="mobile" name="mobile" type="tel" pattern="[0-9]*" placeholder="০১XXXXXXXXX" required>

      <label for="room">রুম নম্বর</label>
      <input id="room" name="room" type="text" placeholder="রুম ৩০৫" required>

      <button type="submit">অনুরোধ জমা দিন</button>
    </form>

    <div class="small" style="margin-top:20px; text-align:center;">প্রয়োজনে, স্ট্যাটাস জানতে অ্যাডমিন প্যানেল চেক করতে বলুন।</div>
  </div>

  <div class="footer">আপনার নেটওয়ার্ক টিম দ্বারা চালিত — দয়া করে দায়িত্বের সাথে ব্যবহার করুন।</div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js" integrity="sha512-BNa5l2c7u5v1wyh2k3X1VmEwZqUq2s2+qg3vH2Yg6N3bQK0k6Wg1o0y2kF8J3jJQ1c0WbqT4kA8Y1ZpZ4P7+DQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
document.addEventListener('click', function(e){
  const msg = document.getElementById('boldMsg');

  if (e.target && e.target.id === 'copyBtn') {
    const code = document.getElementById('newCode').innerText;
    navigator.clipboard.writeText(code).then(()=> {
      msg.innerText = 'কোড ক্লিপবোর্ডে কপি করা হয়েছে ✅';
      msg.style.display = 'block';
      setTimeout(()=> msg.style.display = 'none', 2000);
    });
  }
  if (e.target && e.target.id === 'screenshotBtn') {
    html2canvas(document.querySelector('.success')).then(canvas => {
      const a = document.createElement('a');
      a.href = canvas.toDataURL('image/png');
      a.download = 'wifi-code-request.png';
      a.click();
      msg.innerText = 'স্ক্রিনশট নেওয়া হয়েছে ✔️';
      msg.style.display = 'block';
      setTimeout(()=> msg.style.display = 'none', 2500);
    });
  }
});
</script>
</body>
</html>