<?php
// admin.php - simple admin panel (password protected)
// WARNING: This is minimal auth. Use HTTPS and stronger auth for production.
session_start();
$ADMIN_PASSWORD = 'ReplaceThisWithAStrongPass';

// login
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['admin_pass'])) {
    if (hash_equals($ADMIN_PASSWORD, $_POST['admin_pass'])) {
        $_SESSION['is_admin'] = true;
    } else {
        $login_error = "Wrong password.";
    }
}

// mark processed (simple form action)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['mark_index']) && !empty($_SESSION['is_admin'])) {
    $idx = intval($_POST['mark_index']);
    $file = __DIR__ . '/requests.json';
    $data = json_decode(@file_get_contents($file) ?: '[]', true);
    if (isset($data[$idx])) {
        $data[$idx]['status'] = 'processed';
        $data[$idx]['admin_note'] = $_POST['admin_note'] ?? '';
        $data[$idx]['processed_by'] = 'admin';
        $data[$idx]['processed_at'] = gmdate('Y-m-d H:i:s');
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
    }
    header("Location: ".$_SERVER['REQUEST_URI']);
    exit;
}

if (empty($_SESSION['is_admin'])) {
    // show password form
    ?>
    <!doctype html><html><head><meta name="viewport" content="width=device-width,initial-scale=1"><title>Admin Login</title>
    <style>body{font-family:Inter,Arial;padding:20px;background:#f3f4f6} .card{max-width:420px;margin:30px auto;background:#fff;padding:18px;border-radius:12px;box-shadow:0 6px 18px rgba(2,6,23,.08)}</style>
    </head><body><div class="card">
    <h2>Admin Login</h2>
    <?php if(!empty($login_error)) echo "<div style='color:#b91c1c;margin-bottom:8px'>$login_error</div>"; ?>
    <form method="post">
      <label>Password</label>
      <input name="admin_pass" type="password" style="width:100%;padding:10px;margin-top:6px;border-radius:8px;border:1px solid #e6edf3">
      <div style="margin-top:10px"><button style="padding:10px 12px;background:#111827;color:#fff;border:0;border-radius:8px">Login</button></div>
    </form>
    </div></body></html>
    <?php
    exit;
}

// load requests
$file = __DIR__ . '/requests.json';
$data = json_decode(@file_get_contents($file) ?: '[]', true);
if (!is_array($data)) $data = [];
?>
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Admin - Requests</title>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;500;700;800&display=swap" rel="stylesheet">
<style>
body{font-family:Inter,system-ui;padding:12px;background:#f8fafc;color:#0f172a}
.container{max-width:920px;margin:0 auto}
.header{display:flex;justify-content:space-between;align-items:center;margin-bottom:12px}
.card{background:#fff;border-radius:12px;padding:14px;margin-bottom:12px;box-shadow:0 6px 18px rgba(15,23,42,0.06);display:flex;gap:12px;align-items:center}
.left{flex:1}
.tag{background:#eef2ff;color:#3730a3;padding:6px 10px;border-radius:999px;font-weight:700}
.small{font-size:13px;color:#6b7280}
.btn{padding:8px 10px;border-radius:8px;border:0;font-weight:700;cursor:pointer}
.copy{background:#10b981;color:#fff}
.screen{background:#111827;color:#fff}
.process{background:#2563eb;color:#fff}
.icon{width:54px;height:54px;border-radius:12px;background:linear-gradient(135deg,#ecfeff,#dbeafe);display:flex;align-items:center;justify-content:center;font-weight:800;color:#0f172a}
@keyframes float {from{transform:translateY(0)}to{transform:translateY(-6px)}}
.card:hover{transform:translateY(-4px);transition:all .25s ease}
.admin-note{margin-top:8px;font-size:13px}
</style>
</head>
<body>
<div class="container">
  <div class="header"><h2>Pending Requests</h2><div class="small">Logged in as admin</div></div>
  
  <div class="nav" style="display:flex;gap:10px;margin-bottom:20px">
    <a href="admin.php" style="text-decoration:none;padding:8px 16px;background:#2563eb;color:#fff;border-radius:8px;font-weight:500">Pending Requests</a>
    <a href="process_log.php" style="text-decoration:none;padding:8px 16px;background:#fff;border-radius:8px;color:#0f172a;font-weight:500">Process Log</a>
  </div>

  <?php if (count($data) === 0): ?>
    <div class="card"><div class="left"><div style="font-weight:700">No requests</div><div class="small">No pending or processed requests yet.</div></div></div>
  <?php else: ?>
    <?php foreach ($data as $i => $req): ?>
      <div class="card" id="card-<?=$i?>">
        <div class="icon"><?=htmlspecialchars(substr($req['current_code'], 0,1))?></div>
        <div class="left">
          <div style="display:flex;justify-content:space-between;align-items:center">
            <div>
              <div style="font-weight:800"><?=htmlspecialchars($req['current_code'])?> → <span style="color:#0f172a"><?=htmlspecialchars($req['new_code'])?></span></div>
              <div class="small"><?=htmlspecialchars($req['mobile'])?> · <?=htmlspecialchars($req['room'])?> · <span class="small">Created: <?=htmlspecialchars($req['created_at'])?></span></div>
            </div>
            <div>
              <div style="text-align:right">
                <div class="tag"><?=htmlspecialchars($req['status'])?></div>
              </div>
            </div>
          </div>

          <?php if(!empty($req['admin_note'])): ?>
            <div class="admin-note">Admin: <?=htmlspecialchars($req['admin_note'])?></div>
          <?php endif; ?>

          <div style="margin-top:10px;display:flex;gap:8px">
            <button class="btn copy" data-new="<?=htmlspecialchars($req['new_code'])?>">Copy Code</button>
            <button class="btn screen" data-card="#card-<?=$i?>">Take Screenshot</button>

            <?php if ($req['status'] !== 'processed'): ?>
            <form method="post" style="display:inline">
              <input type="hidden" name="mark_index" value="<?= $i ?>">
              <input type="text" name="admin_note" placeholder="Optional note" style="padding:8px;border-radius:8px;border:1px solid #e6edf3">
              <button class="btn process" type="submit">Mark Processed</button>
            </form>
            <?php else: ?>
              <div style="margin-left:6px;padding:8px;border-radius:8px;background:#ecfccb;color:#365314;font-weight:700">Processed</div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>

  <div style="margin-top:12px" class="small">Tip: Use the screenshot to save a record or share it with the support team.</div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
document.addEventListener('click', function(e){
  if (e.target && e.target.classList.contains('copy')) {
    const code = e.target.dataset.new;
    navigator.clipboard.writeText(code).then(()=> {
      e.target.innerText = 'Copied ✓';
      setTimeout(()=> e.target.innerText = 'Copy Code', 1400);
    });
  }
  if (e.target && e.target.classList.contains('screen')) {
    const selector = e.target.dataset.card;
    const el = document.querySelector(selector);
    if (!el) return;
    html2canvas(el).then(canvas => {
      const a = document.createElement('a');
      a.href = canvas.toDataURL('image/png');
      a.download = 'request-'+Date.now()+'.png';
      a.click();
      e.target.innerText = 'Saved';
      setTimeout(()=> e.target.innerText = 'Take Screenshot', 1400);
    });
  }
});
</script>
</body>
</html>
