<?php
// success.php - displays the new WiFi code
 $code = $_GET['code'] ?? '';
 $oldCode = $_GET['old_code'] ?? '';

if (empty($code)) {
    header("Location: index.php");
    exit;
}

// If old code is not passed, try to get it from the most recent request
if (empty($oldCode)) {
    $file = __DIR__ . '/requests.json';
    if (file_exists($file)) {
        $json = @file_get_contents($file);
        $data = $json ? json_decode($json, true) : [];
        if (is_array($data) && !empty($data)) {
            // Find the most recent request with this new code
            $latestRequest = null;
            $latestTime = 0;
            
            foreach ($data as $request) {
                if ($request['new_code'] === $code) {
                    $requestTime = strtotime($request['created_at']);
                    if ($requestTime > $latestTime) {
                        $latestTime = $requestTime;
                        $latestRequest = $request;
                    }
                }
            }
            
            if ($latestRequest) {
                $oldCode = $latestRequest['current_code'];
            }
        }
    }
}
?>
<!doctype html>
<html lang="bn">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no" />
<title>আপনার নতুন ওয়াইফাই কোড</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
:root {
    --primary: #0071e3;
    --primary-light: #e6f2ff;
    --secondary: #86868b;
    --success: #30d158;
    --success-light: #f0fff4;
    --error: #ff3b30;
    --error-light: #fff2f2;
    --warning: #ff9500;
    --warning-light: #fff8e6;
    --info: #5ac8fa;
    --info-light: #f0f9ff;
    --white: #ffffff;
    --light-gray: #f5f5f7;
    --medium-gray: #d2d2d7;
    --dark-gray: #1d1d1f;
    --text: #1d1d1f;
    --text-secondary: #86868b;
    --shadow: 0 4px 24px rgba(0, 0, 0, 0.08);
    --shadow-hover: 0 8px 32px rgba(0, 0, 0, 0.12);
    --border-radius: 12px;
    --border-radius-large: 18px;
    --transition: all 0.2s ease;
}

* {
    box-sizing: border-box;
    font-family: 'Inter', 'Noto Sans Bengali', -apple-system, BlinkMacSystemFont, sans-serif;
}

body {
    margin: 0;
    background-color: var(--white);
    color: var(--text);
    padding: 20px;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    line-height: 1.5;
}

.container {
    max-width: 560px;
    width: 100%;
}

.card {
    background-color: var(--white);
    border-radius: var(--border-radius-large);
    padding: 40px;
    box-shadow: var(--shadow);
    transition: var(--transition);
    border: 1px solid var(--medium-gray);
}

.header {
    text-align: center;
    margin-bottom: 40px;
}

.logo {
    width: 80px;
    height: 80px;
    background-color: var(--success-light);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
}

.logo i {
    font-size: 36px;
    color: var(--success);
}

h1 {
    font-size: 28px;
    font-weight: 600;
    margin: 0 0 10px;
    color: var(--text);
}

.subtitle {
    font-size: 16px;
    color: var(--text-secondary);
    margin: 0;
    line-height: 1.5;
}

.code-card {
    background-color: var(--light-gray);
    border-radius: var(--border-radius-large);
    padding: 32px;
    margin-bottom: 16px;
    text-align: center;
}

.code-label {
    font-size: 16px;
    font-weight: 500;
    color: var(--text-secondary);
    margin-bottom: 16px;
}

#newCode {
    font-family: 'SF Mono', 'Monaco', 'Inconsolata', 'Roboto Mono', monospace;
    font-size: 36px;
    font-weight: 700;
    letter-spacing: 4px;
    color: var(--primary);
    margin: 0 0 24px;
    padding: 16px 24px;
    background-color: var(--white);
    border-radius: var(--border-radius);
    display: inline-block;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.button-container {
    background-color: var(--white);
    border: 1px solid var(--medium-gray);
    border-radius: var(--border-radius);
    padding: 16px;
    margin-top: 16px;
}

.button-group {
    display: flex;
    gap: 12px;
}

button {
    flex: 1;
    background-color: var(--primary);
    color: var(--white);
    border: 0;
    padding: 12px 16px;
    border-radius: var(--border-radius);
    font-weight: 500;
    font-size: 14px;
    cursor: pointer;
    transition: var(--transition);
    box-shadow: 0 2px 8px rgba(0, 113, 227, 0.2);
    display: flex;
    align-items: center;
    justify-content: center;
}

button i {
    margin-right: 6px;
    font-size: 14px;
}

button:hover {
    background-color: #0077ed;
    box-shadow: 0 4px 12px rgba(0, 113, 227, 0.3);
}

button.secondary {
    background-color: var(--light-gray);
    color: var(--text);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

button.secondary:hover {
    background-color: var(--medium-gray);
}

.message-card {
    background-color: var(--warning-light);
    border-radius: var(--border-radius);
    padding: 20px;
    margin-bottom: 32px;
    border-left: 4px solid var(--warning);
}

.message-card p {
    margin: 0;
    font-size: 15px;
    color: var(--text);
}

.highlight-card {
    background-color: var(--error-light);
    border-radius: var(--border-radius);
    padding: 24px;
    margin-bottom: 32px;
    border-left: 4px solid var(--error);
}

.highlight-card h3 {
    font-size: 18px;
    font-weight: 600;
    margin-top: 0;
    margin-bottom: 16px;
    color: var(--text);
    display: flex;
    align-items: center;
}

.highlight-card h3 i {
    margin-right: 10px;
    color: var(--error);
}

.highlight-card p {
    margin: 0 0 10px;
    font-size: 15px;
}

.highlight-card p:last-child {
    margin-bottom: 0;
}

.contact-card {
    background-color: var(--white);
    border-radius: var(--border-radius);
    padding: 24px;
    margin-bottom: 32px;
    border: 1px solid var(--medium-gray);
}

.contact-card h3 {
    font-size: 18px;
    font-weight: 600;
    margin-top: 0;
    margin-bottom: 16px;
    color: var(--text);
    display: flex;
    align-items: center;
}

.contact-card h3 i {
    margin-right: 10px;
    color: var(--primary);
}

.contact-item {
    display: flex;
    align-items: center;
    margin-bottom: 12px;
}

.contact-item:last-child {
    margin-bottom: 0;
}

.contact-item i {
    width: 24px;
    margin-right: 12px;
    color: var(--primary);
}

.contact-item a {
    color: var(--primary);
    text-decoration: none;
    font-weight: 500;
    font-size: 15px;
}

.contact-item a:hover {
    text-decoration: underline;
}

#boldMsg {
    margin-top: 20px;
    font-weight: 500;
    font-size: 15px;
    display: none;
    padding: 16px;
    border-radius: var(--border-radius);
    background-color: var(--success-light);
    color: var(--success);
    border-left: 4px solid var(--success);
}

.footer {
    font-size: 14px;
    color: var(--text-secondary);
    text-align: center;
    margin-top: 24px;
}

.footer a {
    color: var(--primary);
    text-decoration: none;
}

.footer a:hover {
    text-decoration: underline;
}

.divider {
    height: 1px;
    background-color: var(--medium-gray);
    margin: 32px 0;
}

.info-card {
    background-color: var(--light-gray);
    border-radius: var(--border-radius);
    padding: 24px;
    margin-bottom: 24px;
}

.info-card h3 {
    font-size: 18px;
    font-weight: 600;
    margin-top: 0;
    margin-bottom: 16px;
    color: var(--text);
    display: flex;
    align-items: center;
}

.info-card h3 i {
    margin-right: 10px;
    color: var(--primary);
}

.info-card ul {
    margin: 0;
    padding-left: 20px;
}

.info-card ul li {
    margin-bottom: 8px;
    font-size: 15px;
}

.info-card ul li:last-child {
    margin-bottom: 0;
}

@media (max-width: 480px) {
    body { padding: 16px; }
    .card { padding: 24px; }
    h1 { font-size: 24px; }
    #newCode { font-size: 28px; }
    .button-group { flex-direction: column; gap: 10px; }
}

/* Hide canvas temporarily */
#tempCanvas {
    position: absolute;
    left: -9999px;
    top: -9999px;
}
</style>
</head>
<body>
<div class="container">
  <div class="card">
    <div class="header">
      <div class="logo">
        <i class="fas fa-check-circle"></i>
      </div>
      <h1>অনুরোধ জমা দেওয়া হয়েছে!</h1>
      <p class="subtitle">আপনার নতুন ওয়াইফাই কোড নিচে দেওয়া হয়েছে</p>
    </div>

    <div class="code-card">
      <div class="code-label">আপনার নতুন ওয়াইফাই কোড</div>
      <p id="newCode"><?php echo htmlspecialchars($code); ?></p>
      
      <div class="button-container">
        <div class="button-group">
          <button id="copyBtn"><i class="fas fa-copy"></i> কোড কপি করুন</button>
          <button id="screenshotBtn" class="secondary"><i class="fas fa-camera"></i> সেভ করুন</button>
          <button id="saveNoteBtn" class="secondary"><i class="fas fa-sticky-note"></i> নোট হিসেবে সেভ করুন</button>
        </div>
      </div>
    </div>

   

    <div class="highlight-card">
      <h3><i class="fas fa-exclamation-circle"></i> গুরুত্বপূর্ণ নির্দেশনা</h3>
      <p><strong>মারুফ ভাইকে অনুরোধ গ্রহণ করতে বলুন</strong></p>
      <p>অনুরোধ গ্রহণ না করলে কোড পরিবর্তন হবে না</p>
    </div>

    <div class="contact-card">
      <h3><i class="fas fa-user-tie"></i> মারুফ ভাইয়ের সাথে যোগাযোগ</h3>
      <div class="contact-item">
        <i class="fas fa-phone"></i>
        <a href="tel:+8801750979495">কল করুন: +8801750979495</a>
      </div>
      <div class="contact-item">
        <i class="fab fa-whatsapp"></i>
        <a href="https://wa.me/+8801750979495" target="_blank">হোয়াটসঅ্যাপ: +8801750979495</a>
      </div>
      <div class="contact-item">
        <i class="fab fa-facebook-messenger"></i>
        <a href="https://www.facebook.com/maruf5bd" target="_blank">মেসেঞ্জার: maruf5bd</a>
      </div>
    </div>
    
     <div class="message-card">
      <p><i class="fas fa-clock"></i> নতুন কোড ব্যবহার করার আগে দয়া করে <strong>১০ মিনিট</strong> অপেক্ষা করুন।</p>
    </div>
    
    
    

    <div id="boldMsg"></div>

    <div class="divider"></div>

    <div class="info-card">
      <h3><i class="fas fa-info-circle"></i> গুরুত্বপূর্ণ নির্দেশাবলী</h3>
      <ul>
        <li>মারুফ ভাইকে অনুরোধ গ্রহণ করতে বলুন</li>
        <li>১০ মিনিট পরে নতুন কোড ব্যবহার করুন</li>
        <li>কোডটি সুরক্ষিত স্থানে সংরক্ষণ করুন</li>
      </ul>
    </div>

    <div class="footer">
      <a href="index.php"><i class="fas fa-arrow-left"></i> হোম পেজে ফিরে যান</a>
      <p>© 2023 RvWIFI Payment</p>
    </div>
  </div>
</div>

<canvas id="tempCanvas"></canvas>

<script>
// Store codes from PHP
const oldCode = '<?php echo htmlspecialchars($oldCode); ?>';
const newCode = '<?php echo htmlspecialchars($code); ?>';

document.addEventListener('click', function(e){
  const msg = document.getElementById('boldMsg');

  if (e.target && e.target.id === 'copyBtn') {
    const code = document.getElementById('newCode').innerText;
    if (navigator.clipboard && navigator.clipboard.writeText) {
      navigator.clipboard.writeText(code).then(()=> {
        showMessage('✅ কোড ক্লিপবোর্ডে কপি করা হয়েছে!');
      }).catch(() => {
        fallbackCopyText(code);
      });
    } else {
      fallbackCopyText(code);
    }
  }
  
  if (e.target && e.target.id === 'screenshotBtn') {
    takeScreenshot();
  }
  
  if (e.target && e.target.id === 'saveNoteBtn') {
    saveAsNote();
  }
});

function fallbackCopyText(text) {
  const textArea = document.createElement('textarea');
  textArea.value = text;
  textArea.style.position = 'fixed';
  textArea.style.left = '-999999px';
  textArea.style.top = '-999999px';
  document.body.appendChild(textArea);
  textArea.focus();
  textArea.select();
  try {
    document.execCommand('copy');
    showMessage('✅ কোড ক্লিপবোর্ডে কপি করা হয়েছে!');
  } catch (err) {
    showMessage('❌ কোড কপি করতে সমস্যা হয়েছে');
  }
  document.body.removeChild(textArea);
}

// Simple takeScreenshot function - no font loading needed
function takeScreenshot() {
  createCodeImage();
  showMessage('✅ কোড ইমেজ সেভ করা হয়েছে!');
}

// Updated createCodeImage function with English fallback
function createCodeImage() {
  const canvas = document.getElementById('tempCanvas');
  const ctx = canvas.getContext('2d');
  
  // Set canvas size for better quality
  const width = 600;
  const height = oldCode ? 480 : 400;
  canvas.width = width;
  canvas.height = height;
  
  // Create modern gradient background
  const gradient = ctx.createLinearGradient(0, 0, 0, height);
  gradient.addColorStop(0, '#e6f2ff');
  gradient.addColorStop(1, '#ffffff');
  ctx.fillStyle = gradient;
  ctx.fillRect(0, 0, width, height);
  
  // Add decorative top bar
  const topGradient = ctx.createLinearGradient(0, 0, width, 0);
  topGradient.addColorStop(0, '#0071e3');
  topGradient.addColorStop(1, '#5ac8fa');
  ctx.fillStyle = topGradient;
  ctx.fillRect(0, 0, width, 8);
  
  // Add main title with shadow - ENGLISH FALLBACK
  ctx.shadowColor = 'rgba(0, 0, 0, 0.1)';
  ctx.shadowBlur = 4;
  ctx.shadowOffsetY = 2;
  ctx.fillStyle = '#1d1d1f';
  ctx.font = 'bold 36px Arial, sans-serif';
  ctx.textAlign = 'center';
  ctx.fillText('WiFi Code', width/2, 60);
  
  // Reset shadow
  ctx.shadowColor = 'transparent';
  ctx.shadowBlur = 0;
  ctx.shadowOffsetY = 0;
  
  // Add date
  ctx.fillStyle = '#86868b';
  ctx.font = '16px Arial, sans-serif';
  const dateText = 'Date: ' + new Date().toLocaleDateString('en-US');
  ctx.fillText(dateText, width/2, 90);
  
  // Add new code section with enhanced styling
  ctx.fillStyle = '#0071e3';
  ctx.font = 'bold 22px Arial, sans-serif';
  ctx.fillText('New Code:', width/2, 140);
  
  // Draw new code box with gradient and shadow
  ctx.shadowColor = 'rgba(0, 113, 227, 0.2)';
  ctx.shadowBlur = 12;
  ctx.shadowOffsetY = 4;
  
  const boxGradient = ctx.createLinearGradient(0, 160, 0, 230);
  boxGradient.addColorStop(0, '#f0f6ff');
  boxGradient.addColorStop(1, '#e6f2ff');
  ctx.fillStyle = boxGradient;
  ctx.strokeStyle = '#0071e3';
  ctx.lineWidth = 3;
  roundRect(ctx, 80, 160, width-160, 70, 12);
  ctx.fill();
  ctx.stroke();
  
  // Reset shadow for text
  ctx.shadowColor = 'transparent';
  ctx.shadowBlur = 0;
  ctx.shadowOffsetY = 0;
  
  // Add new code text with better visibility
  ctx.fillStyle = '#0071e3';
  ctx.font = 'bold 42px "Courier New", monospace';
  ctx.textAlign = 'center';
  ctx.fillText(newCode, width/2, 210);
  
  // Add old code section if available
  let yOffset = 260;
  if (oldCode) {
    ctx.fillStyle = '#86868b';
    ctx.font = 'bold 18px Arial, sans-serif';
    ctx.fillText('Old Code:', width/2, yOffset);
    
    // Draw old code box
    ctx.fillStyle = '#f5f5f7';
    ctx.strokeStyle = '#d2d2d7';
    ctx.lineWidth = 2;
    roundRect(ctx, 150, yOffset + 15, width-300, 45, 8);
    ctx.fill();
    ctx.stroke();
    
    // Add old code text
    ctx.fillStyle = '#86868b';
    ctx.font = 'bold 24px "Courier New", monospace';
    ctx.fillText(oldCode, width/2, yOffset + 45);
    
    yOffset += 85;
  }
  
  // Add warning box
  ctx.fillStyle = '#fff8e6';
  ctx.strokeStyle = '#ff9500';
  ctx.lineWidth = 2;
  roundRect(ctx, 60, yOffset, width-120, 50, 8);
  ctx.fill();
  ctx.stroke();
  
  // Add warning icon and text - ENGLISH
  ctx.fillStyle = '#ff9500';
  ctx.font = '20px Arial';
  ctx.fillText('⚠️', width/2 - 110, yOffset + 32);
  
  ctx.font = 'bold 15px Arial, sans-serif';
  ctx.fillText('Wait 10 minutes before use', width/2 + 10, yOffset + 32);
  
  // Add footer with branding
  yOffset += 70;
  ctx.fillStyle = '#86868b';
  ctx.font = '14px Arial, sans-serif';
  ctx.fillText('RvWIFI Payment System', width/2, yOffset);
  
  // Add decorative bottom bar
  const bottomGradient = ctx.createLinearGradient(0, height-8, width, height-8);
  bottomGradient.addColorStop(0, '#0071e3');
  bottomGradient.addColorStop(1, '#5ac8fa');
  ctx.fillStyle = bottomGradient;
  ctx.fillRect(0, height-8, width, 8);
  
  // Download the image
  const timestamp = new Date().getTime();
  downloadCanvas(canvas, 'wifi-code-' + newCode + '-' + timestamp + '.png');
}

// Helper function for rounded rectangles
function roundRect(ctx, x, y, width, height, radius) {
  ctx.beginPath();
  ctx.moveTo(x + radius, y);
  ctx.lineTo(x + width - radius, y);
  ctx.quadraticCurveTo(x + width, y, x + width, y + radius);
  ctx.lineTo(x + width, y + height - radius);
  ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);
  ctx.lineTo(x + radius, y + height);
  ctx.quadraticCurveTo(x, y + height, x, y + height - radius);
  ctx.lineTo(x, y + radius);
  ctx.quadraticCurveTo(x, y, x + radius, y);
  ctx.closePath();
}

function downloadCanvas(canvas, filename) {
  // For Android and mobile devices, directly download image
  const a = document.createElement('a');
  a.href = canvas.toDataURL('image/png', 0.9);
  a.download = filename;
  document.body.appendChild(a);
  a.click();
  document.body.removeChild(a);
}

function saveAsNote() {
  let noteText = `ওয়াইফাই কোড\nতারিখ: ${new Date().toLocaleDateString('bn-BD')}\nনতুন কোড: ${newCode}`;
  
  if (oldCode) {
    noteText = `ওয়াইফাই কোড\nতারিখ: ${new Date().toLocaleDateString('bn-BD')}\nপুরাতন কোড: ${oldCode}\nনতুন কোড: ${newCode}`;
  }
  
  if (navigator.share) {
    navigator.share({
      title: 'ওয়াইফাই কোড',
      text: noteText
    }).then(() => {
      showMessage('✅ নোট হিসেবে সেভ করা হয়েছে!');
    }).catch(() => {
      fallbackSaveNote(noteText);
    });
  } else {
    fallbackSaveNote(noteText);
  }
}

function fallbackSaveNote(text) {
  if (navigator.clipboard && navigator.clipboard.writeText) {
    navigator.clipboard.writeText(text).then(() => {
      showMessage('✅ নোট টেক্সট কপি করা হয়েছে! আপনি এটি আপনার নোট অ্যাপে পেস্ট করতে পারেন।');
    });
  } else {
    fallbackCopyText(text);
  }
}

function showMessage(message) {
  const msg = document.getElementById('boldMsg');
  msg.innerText = message;
  msg.style.display = 'block';
  setTimeout(() => msg.style.display = 'none', 3000);
}
</script>
</body>
</html>