<?php
$new_code = $_GET['code'] ?? '';
$auto_approved = isset($_GET['auto_approved']) && $_GET['auto_approved'] === '1';

if (empty($new_code)) {
    header("Location: index.php");
    exit;
}
?>
<!doctype html>
<html lang="bn">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1,user-scalable=no" />
<title>অনুরোধ সফল হয়েছে</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@300;400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
:root {
    --primary: #0071e3;
    --primary-light: #e6f2ff;
    --success: #30d158;
    --success-light: #f0fff4;
    --warning: #ff9500;
    --warning-light: #fff8e6;
    --white: #ffffff;
    --light-gray: #f5f5f7;
    --medium-gray: #d2d2d7;
    --text: #1d1d1f;
    --text-secondary: #86868b;
    --shadow: 0 4px 24px rgba(0, 0, 0, 0.08);
    --border-radius: 12px;
    --border-radius-large: 18px;
    --transition: all 0.2s ease;
}

* {
    box-sizing: border-box;
    font-family: 'Inter', 'Noto Sans Bengali', -apple-system, BlinkMacSystemFont, sans-serif;
}

body {
    margin: 0;
    background-color: var(--white);
    color: var(--text);
    padding: 20px;
    display: flex;
    justify-content: center;
    align-items: center;
    min-height: 100vh;
    line-height: 1.5;
}

.container {
    max-width: 560px;
    width: 100%;
}

.card {
    background-color: var(--white);
    border-radius: var(--border-radius-large);
    padding: 40px;
    box-shadow: var(--shadow);
    border: 1px solid var(--medium-gray);
}

.success-icon {
    width: 80px;
    height: 80px;
    background-color: var(--success-light);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 24px;
    animation: scaleIn 0.4s ease;
}

.success-icon i {
    font-size: 36px;
    color: var(--success);
}

@keyframes scaleIn {
    from { transform: scale(0); }
    to { transform: scale(1); }
}

h1 {
    font-size: 28px;
    font-weight: 600;
    margin: 0 0 16px;
    color: var(--text);
    text-align: center;
}

.subtitle {
    font-size: 16px;
    color: var(--text-secondary);
    text-align: center;
    margin: 0 0 32px;
}

.code-display {
    background: linear-gradient(135deg, var(--primary-light), var(--success-light));
    border-radius: var(--border-radius);
    padding: 32px;
    text-align: center;
    margin-bottom: 24px;
    border: 2px solid var(--primary);
}

.code-label {
    font-size: 14px;
    font-weight: 500;
    color: var(--text-secondary);
    margin-bottom: 12px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.code-value {
    font-size: 48px;
    font-weight: 700;
    color: var(--primary);
    letter-spacing: 4px;
    margin-bottom: 16px;
    font-family: 'Courier New', monospace;
}

.copy-button {
    background-color: var(--primary);
    color: var(--white);
    border: 0;
    padding: 12px 24px;
    border-radius: var(--border-radius);
    font-weight: 500;
    font-size: 15px;
    cursor: pointer;
    transition: var(--transition);
    display: inline-flex;
    align-items: center;
    gap: 8px;
}

.copy-button:hover {
    background-color: #0077ed;
}

.copy-button i {
    font-size: 16px;
}

.alert {
    padding: 20px;
    border-radius: var(--border-radius);
    margin-bottom: 24px;
    border-left: 4px solid;
}

.alert-success {
    background-color: var(--success-light);
    border-color: var(--success);
    color: #166534;
}

.alert-warning {
    background-color: var(--warning-light);
    border-color: var(--warning);
    color: #92400e;
}

.alert h3 {
    margin: 0 0 8px;
    font-size: 18px;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 8px;
}

.alert p {
    margin: 0;
    font-size: 15px;
    line-height: 1.6;
}

.info-box {
    background-color: var(--light-gray);
    border-radius: var(--border-radius);
    padding: 24px;
    margin-bottom: 24px;
}

.info-box h3 {
    font-size: 16px;
    font-weight: 600;
    margin: 0 0 12px;
    color: var(--text);
}

.info-box ul {
    margin: 0;
    padding-left: 20px;
}

.info-box ul li {
    margin-bottom: 8px;
    font-size: 14px;
    color: var(--text);
}

.info-box ul li:last-child {
    margin-bottom: 0;
}

.back-button {
    display: inline-block;
    color: var(--primary);
    text-decoration: none;
    font-weight: 500;
    font-size: 15px;
    padding: 12px 24px;
    border-radius: var(--border-radius);
    border: 2px solid var(--primary);
    transition: var(--transition);
    text-align: center;
    width: 100%;
}

.back-button:hover {
    background-color: var(--primary);
    color: var(--white);
}

@media (max-width: 480px) {
    body { padding: 16px; }
    .card { padding: 24px; }
    h1 { font-size: 24px; }
    .code-value { font-size: 36px; }
}
</style>
</head>
<body>
<div class="container">
  <div class="card">
    <div class="success-icon">
      <i class="fas fa-check"></i>
    </div>

    <h1>অনুরোধ সফল হয়েছে!</h1>
    <p class="subtitle">আপনার নতুন ওয়াইফাই কোড তৈরি হয়েছে</p>

    <?php if ($auto_approved): ?>
      <div class="alert alert-success">
        <h3><i class="fas fa-check-circle"></i> স্বয়ংক্রিয়ভাবে অনুমোদিত</h3>
        <p>আপনার অনুরোধ স্বয়ংক্রিয়ভাবে অনুমোদিত হয়েছে। আপনি এখনই নতুন কোড ব্যবহার শুরু করতে পারবেন।</p>
      </div>
    <?php else: ?>
      <div class="alert alert-warning">
        <h3><i class="fas fa-hourglass-half"></i> অনুমোদনের জন্য অপেক্ষমাণ</h3>
        <p>আপনার অনুরোধ সফলভাবে জমা হয়েছে। নতুন কোড ব্যবহার করার আগে অনুগ্রহ করে <strong>মারMARUFভাই</strong> এর অনুমোদনের জন্য অপেক্ষা করুন।</p>
      </div>
    <?php endif; ?>

    <div class="code-display">
      <div class="code-label">আপনার নতুন ওয়াইফাই কোড</div>
      <div class="code-value" id="newCode"><?= htmlspecialchars($new_code) ?></div>
      <button class="copy-button" onclick="copyCode()">
        <i class="fas fa-copy"></i>
        <span id="copyText">কপি করুন</span>
      </button>
    </div>

    <div class="info-box">
      <h3>গুরুত্বপূর্ণ নির্দেশনা:</h3>
      <ul>
        <?php if ($auto_approved): ?>
          <li><strong>কোড সক্রিয়:</strong> আপনার নতুন কোড এখনই ব্যবহারের জন্য প্রস্তুত</li>
          <li>পুরাতন কোড আর কাজ করবে না</li>
        <?php else: ?>
          <li><strong>অপেক্ষা করুন:</strong> অনুমোদনের জন্য ১০-১৫ মিনিট সময় লাগতে পারে</li>
          <li>অনুমোদিত না হওয়া পর্যন্ত পুরাতন কোড ব্যবহার চালিয়ে যান</li>
          <li>মারMARUFভাইকে কল বা হোয়াটসঅ্যাপে মেসেজ করুন</li>
        <?php endif; ?>
        <li>এই কোড কাউকে শেয়ার করবেন না</li>
        <li>কোডটি নিরাপদ জায়গায় সংরক্ষণ করুন</li>
        <li>স্ক্রিনশট নিয়ে রাখতে পারেন</li>
      </ul>
    </div>

    <a href="index.php" class="back-button">
      <i class="fas fa-home"></i> হোমপেজে ফিরে যান
    </a>
  </div>
</div>

<script>
function copyCode() {
    const code = document.getElementById('newCode').innerText;
    const copyText = document.getElementById('copyText');
    
    navigator.clipboard.writeText(code).then(() => {
        copyText.innerHTML = '<i class="fas fa-check"></i> কপি হয়েছে!';
        setTimeout(() => {
            copyText.innerHTML = 'কপি করুন';
        }, 2000);
    }).catch(err => {
        // Fallback for older browsers
        const textArea = document.createElement('textarea');
        textArea.value = code;
        document.body.appendChild(textArea);
        textArea.select();
        document.execCommand('copy');
        document.body.removeChild(textArea);
        
        copyText.innerHTML = '<i class="fas fa-check"></i> কপি হয়েছে!';
        setTimeout(() => {
            copyText.innerHTML = 'কপি করুন';
        }, 2000);
    });
}
</script>
</body>
</html>