<?php
// index.php - user form (mobile optimized)
// No frameworks. Make sure PHP can write to requests.json (chmod 664 or 666 for testing).
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_code = trim($_POST['current_code'] ?? '');
    $mobile = trim($_POST['mobile'] ?? '');
    $room = trim($_POST['room'] ?? '');

    if ($current_code === '' || $mobile === '' || $room === '') {
        $error = "Please fill all fields.";
    } else {
        $new_code = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
        $id = uniqid('req_', true); // unique request id

        $entry = [
            'id' => $id,
            'current_code' => $current_code,
            'new_code' => $new_code,
            'mobile' => $mobile,
            'room' => $room,
            'created_at' => gmdate('Y-m-d H:i:s'),
            'status' => 'pending'
        ];

        $file = __DIR__ . '/requests.json';
        $data = [];
        if (file_exists($file)) {
            $json = @file_get_contents($file);
            $data = $json ? json_decode($json, true) : [];
            if (!is_array($data)) $data = [];
        }
        $data[] = $entry;
        file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
        $success = true;
    }

}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Request New WiFi Code</title>
<link rel="preconnect" href="https://fonts.gstatic.com">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;500;700;800&display=swap" rel="stylesheet">
<style>
:root{--accent:#4f46e5;--muted:#6b7280}
*{box-sizing:border-box;font-family:Inter,system-ui,-apple-system,Segoe UI,Roboto,"Helvetica Neue",Arial}
body{margin:0;background:#f8fafc;color:#0f172a;padding:18px}
.container{max-width:720px;margin:0 auto}
.card{background:#fff;border-radius:14px;padding:18px;box-shadow:0 6px 18px rgba(15,23,42,0.06);margin-bottom:14px}
h1{font-size:20px;margin:0 0 8px}
label{display:block;font-size:13px;margin:10px 0 6px;color:var(--muted)}
input[type=text], input[type=tel] {width:100%;padding:12px;border-radius:10px;border:1px solid #e6edf3;font-size:15px}
button{background:var(--accent);color:#fff;border:0;padding:12px 14px;border-radius:10px;font-weight:600;cursor:pointer}
.small{font-size:13px;color:var(--muted)}
.success{background:#ecfeff;border-left:4px solid #06b6d4;padding:12px;border-radius:8px;margin-bottom:12px}
.notice{background:#fff7ed;border-left:4px solid #fb923c;padding:12px;border-radius:8px;margin-top:10px}
.wait-note{margin-top:12px;font-weight:700;color:#b91c1c}
.footer{font-size:12px;color:var(--muted);text-align:center;margin-top:18px}
.center{display:flex;gap:10px;align-items:center}
@media (max-width:480px){h1{font-size:18px}}
</style>
</head>
<body>
<div class="container">
  <div class="card">
    <h1>Request New 6-digit Code</h1>
    <p class="small">Enter current code, mobile and room number. After submit, wait <strong>10 minutes</strong> before using the new code.</p>

    <?php if(!empty($error)): ?>
      <div class="notice"><?=htmlspecialchars($error)?></div>
    <?php endif; ?>

    <?php if(!empty($success)): ?>
      <div class="success">
        <div style="font-weight:700">Request submitted!</div>
        <div style="margin-top:6px">New code: <span id="newCode" style="font-weight:800;font-size:20px;letter-spacing:2px;"><?php echo htmlspecialchars($new_code); ?></span></div>
        <div class="small" style="margin-top:8px">Please wait <strong>10 minutes</strong> before trying to use the new code.</div>
        <div style="margin-top:8px">
          <button id="copyBtn">Copy Code</button>
          <button id="screenshotBtn" style="margin-left:8px;background:#111827">Take Screenshot</button>
        </div>
        <div id="boldMsg" style="margin-top:12px;font-weight:800;display:none"></div>
      </div>
    <?php endif; ?>

    <form method="post" autocomplete="off">
      <label for="current_code">Current Code</label>
      <input id="current_code" name="current_code" type="text" placeholder="e.g. 8465Z" required>

      <label for="mobile">Mobile (01xxxxxxxxx)</label>
      <input id="mobile" name="mobile" type="tel" pattern="[0-9]*" placeholder="01XXXXXXXXX" required>

      <label for="room">Room No</label>
      <input id="room" name="room" type="text" placeholder="Room 305" required>

      <div style="margin-top:12px" class="center">
        <button type="submit">Submit Request</button>
        <div style="flex:1;text-align:right" class="small">Fast & mobile-friendly ✓</div>
      </div>
    </form>

    <div class="small" style="margin-top:12px">If you want, ask admin to check the admin panel for status.</div>
  </div>

  <div class="footer">Powered by your network team — please use responsibly.</div>
</div>

<!-- html2canvas for screenshot -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js" integrity="sha512-BNa5l2c7u5v1wyh2k3X1VmEwZqUq2s2+qg3vH2Yg6N3bQK0k6Wg1o0y2kF8J3jJQ1c0WbqT4kA8Y1ZpZ4P7+DQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
document.addEventListener('click', function(e){
  if (e.target && e.target.id === 'copyBtn') {
    const code = document.getElementById('newCode').innerText;
    navigator.clipboard.writeText(code).then(()=> {
      const msg = document.getElementById('boldMsg');
      msg.innerText = 'Code copied to clipboard ✅';
      msg.style.display = 'block';
      msg.style.fontSize = '18px';
      setTimeout(()=> msg.style.display = 'none', 2000);
    });
  }
  if (e.target && e.target.id === 'screenshotBtn') {
    html2canvas(document.querySelector('.card')).then(canvas => {
      const a = document.createElement('a');
      a.href = canvas.toDataURL('image/png');
      a.download = 'code-request.png';
      a.click();
      const msg = document.getElementById('boldMsg');
      msg.innerText = 'Screenshot taken ✔️';
      msg.style.display = 'block';
      msg.style.fontSize = '20px';
      setTimeout(()=> msg.style.display = 'none', 2500);
    });
  }
});
</script>
</body>
</html>
